#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Twisting SkiesMod01.fsh  by   Tater
//https://www.shadertoy.com/view/7tf3Dr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))
#define pi 3.141596
#define STEPS 200.0
#define MDIST 250.0
#define pmod(p,x) (mod(p, x) - (x)*0.5)

vec3 g1 = vec3(0);
float donut( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

vec2 map2(vec3 p){
    vec3 po = p;
    float t = iTime*0.2;

    vec2 a = vec2(1);
    a.x = donut(p,vec2(2,0.5));
    vec2 b = vec2(2);
    p.yz*=rot(pi/2.0);
    b.x = donut(p+vec3(2.5,0,0),vec2(2,0.5));
    
    //Colors
    a.y = mix(1.0,2.0,clamp(30.0*sin(p.y*7.0+t*3.0),0.0,1.0));
    vec3 p2 = p;
    p2+=t*4.0;
    b.y = mix(1.0,2.0,step(sin((p2.x)*10.0)*sin((p2.y)*10.0)*sin((p2.z)*10.0),-0.5));

    b = (b.x < a.x) ? b:a;
    
    a = vec2(donut(p+vec3(-2.5,0,0),vec2(2,0.5)),3.0);
    g1 += 0.05/(0.5+abs(a.x))*vec3(1.000,0.588,0.122);
    b = (b.x < a.x) ? b:a;
    
    return b;
}
vec2 map3(vec3 p){
    vec3 po = p;
    float sep = 15.0;
    p.x = pmod(p.x,sep);
    vec2 a = map2(p);
    p = po;
    p.x+=sep*0.5;
    p.x = pmod(p.x,sep);
    p.zy*=rot(pi/2.0);
    vec2 b = map2(p);
    b = (b.x < a.x) ? b:a;
    return b;
}
vec2 map(vec3 p){
    vec3 po2 = p;
    p.zy*=rot(pi/2.0);
    
    
    vec3 po = p;
    float t = iTime;
    p.y+=6.0;
    float th = atan(po.y,po.x)/(2.0*pi)+0.5;
    float r = length(po.yx)-10.;
    th*=60.0;
    p.y = r;
    p.x = th;
    p.x+=t*9.0;
    vec2 a = map3(p);
    
    po.xy*=rot(p.z*0.05);
    //Big rings
    float size = 15.0;
    vec3 p2 = po; 
    
    p2.xy = abs(p2.xy)-vec2(1,1)*4.5;
    p2.xy*=rot(-0.9);
    p2.y-=size*10.0;
    p2.xz*=rot(pi/2.0);
    p2.xy*=rot(t*0.2);
    p = p2;
    
    th = atan(p2.y,p2.x)/(2.0*pi)+0.5;
    
    r = length(p2.yx)-10.0*size;
    th*=60.0*size;
    p.y = r;
    p.x = th;

    
    vec2 b = map3(p);
    b.x*=0.7;
    b = (b.x < a.x) ? b:a;
    
    //Cut Cynlinder
    p = po;
    a.x = length(p.xy)-50.0;
    a.y = 2.0;
    b.x = max(a.x,b.x);

    p.z+=sin(p.x+t*6.0)*0.025;
    p.z+=sin(p.y+t*6.0)*0.02;
    a = vec2(length(p.z),4.0);
    b = (b.x < a.x) ? b:a;

    //Pillars
    p = po2;
    p.xz = abs(p.xz)-vec2(70);
    a = vec2(length(p.xz)-6.5,5.0);
    a.x*=0.7;
    b = (b.x < a.x) ? b:a;
    
    return b;
}


vec3 norm(vec3 p){
    vec2 e= vec2(0.0005,0);
    return normalize(map(p).x-vec3(
    map(p-e.xyy).x,
    map(p-e.yxy).x,
    map(p-e.yyx).x));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-0.5*iResolution.xy)/iResolution.y;
    vec3 col = vec3(0);
    float t = iTime;
    float t2 = t*0.05;
    float outside = 80.0;
    
    vec2 off = vec2(outside*sin(t2),outside*cos(t2));
    
    vec3 ro = vec3(off.x,8.0,off.y);
    vec3 lk = vec3(0,14,0);
    vec3 f = normalize(lk-ro);
    vec3 ra = normalize(cross(vec3(0,1,0),f));
    vec3 rd = f*1.0+uv.x*ra+uv.y*cross(f,ra);
    vec3 p = ro;
    float shad = 0.0;
    float dO = 0.0;
    float dO2;
    vec2 d;
    float bnc = 0.0;
    float dist = 0.0;
    for(float i = 0.0; i < STEPS; i++){
        p = ro+rd*dO;
        d = map(p);
        d.x = abs(d.x);
        if(abs(d.x) < 0.001) {
            if(d.y==3.0) {
               d.x=0.1;
            }
            else{
            shad = (i)/(STEPS);
            if(bnc == 0.0)dist=dO;
            if(bnc== 1.0||d.y!=4.0) {shad=i/STEPS; break; d.y = 0.0;}
            ro += rd*dO;
            vec3 n = norm(ro);
            rd = reflect(rd,n);
            ro += 0.1;
            dO = 0.0;
            i=0.0;
            bnc++;
            }
            
        }
        if(dO2>MDIST){
        if(bnc==0.0)p = ro+rd*MDIST;
        d.y = 0.0;
        break;
        }
        dO += d.x;
        dO2 += d.x;
    }
    vec3 po = p;
    p.y-=5.0;
    vec3 sky = mix(vec3(0.012,0.490,0.647),vec3(0.145,0.118,0.522),clamp(p.y*0.01,0.0,1.0));
    sky = mix(sky,vec3(1.000,0.773,0.141) * clamp(pow(abs(1.0 / (100.0 * length(p.xy*0.0004))),3.0),0.0,0.9),
    pow(abs(1.0 / (100.0 * length(p.xy*0.0004))),3.9));
    p=po;
    vec3 al = vec3(0);
    if(d.y!=0.0)shad = 1.0-shad;
    if(d.y==1.0){
    al = vec3(0.310,0.122,1.000);
    }
    if(d.y==2.0) {
    al = vec3(1.000,0.588,0.122);
    }
    if(d.y==5.0) {
    al = vec3(0.8);
    }
    if(d.y==4.0) {
    al = sky;
    }
    vec3 n = norm(p);
    vec3 ld = vec3(1,1,-1);
    float spec = pow(max(dot(n,normalize(-rd)),0.0),30.0);
    col = vec3(shad)*al;
    if(d.y!=0.0&&d.y!=5.0){
    col+=spec;
    }
    if(d.y==5.0){
    col+=spec*0.2;
    }
    if(d.y==0.0)col = mix(col,sky,clamp(dO2/200.0,0.0,1.0));
    col += min(g1*0.25,1.0);
    

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

